%define module_name Module-Starter-AddModule
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Distribution/Guess/BuildSystem.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec/Functions.pm) perl(Module/Starter.pm) perl(Module/Starter/Simple.pm) perl(Module/Starter/Smart.pm) perl(Test/More.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.011
Release: alt1
Summary: Add a module to a distribution
Group: Development/Perl
License: artistic_2
URL: https://github.com/briandfoy/module-starter-addmodule

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BR/BRIANDFOY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`Module::Starter::Simple' and `Module::Starter::Smart' (which relies
on `::Simple') try to construct the MANIFEST file themselves. This is
the wrong approach since it doesn't not take into account build file
subclasses or MANIFEST.SKIP.

Once you have the build file, let it do it's job by running its `manifest'
target.

Furthermore, `Module::Starter::Smart' doesn't explicitly inherit from
`Module::Starter::Simple', but this module inserts the inheritance
relationship for you automatically.

=over 4

=item create_MANIFEST

Overrides the `create_MANIFEST' in `Module::Starter::Simple' to use
the `manifest' target of the build system instead of trying to create 
the `MANIFEST' file directly. It automatically figures out the build
system you use.

This assumes that your `make' program is called `make'. If it's 
something else, such as `dmake', set the `make' configuration. This
only matters if you are using Makefile.PL.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.pod Changes SECURITY.md LICENSE examples
%perl_vendor_privlib/M*

%changelog
