%define module_name Mojar-Cron
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(IO/Socket/SSL.pm) perl(Module/Metadata.pm) perl(Mojar.pm) perl(Mojolicious.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.501
Release: alt1
Summary: Cron-style time patterns and algorithm
Group: Development/Perl
License: artistic_2
URL: https://niczero.github.io/mojar

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NI/NICZERO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
A time pattern is a sequence of six components: second, minute, hour, day,
month, weekday (the component for 'second' may be omitted for brevity and
consistency with standard cron syntax) and supports `@'-expressions in the
weekday component.  Each of the first four components consists of a
comma-separated list of patterns.

  2
  1,3,5
  1-4,6
  */2

The 'month' component can use those patterns, but may also use English prefices
in place of numbers.

  apr-jun,oct-dec  # instead of 4-6,10-12

The 'weekday' component can do similarly.

  mon-fri  # instead of 1-5
  mon,wed,fri  # instead of 1,3,5

(Note that this implementation also supports 'wrap around' patterns such as
`fri-mon' and `oct-mar'.)

In keeping with standard cron, a time pattern may specify sequences for both day
and weekday in the same pattern.  This can cause confusion because the pattern
is satisfied if either sequence is satisfied.

  00 00 00 01  * mon  # midnight on the first of each month and also each Monday

The weekday component may use `@'-expressions, but in this case the 'day' and
'month' components must be unspecified.

  00 00 00  *  * @mon#1      # first Monday of each month
  00 00 16  *  * @5#L        # last Friday of each month
  00 00 16  *  * @week#L     # last week day (Mon-Fri) of each month
  00 00 03  *  * @weekend#1  # first weekend day (Sat-Sun) of each month

There are also special expressions which can replace the whole time pattern.

  00 01 00  *  * *  # @nightly
  00 01 06  *  * *  # @morningly
  00 01 12  *  * *  # @daily
  00 01 18  *  * *  # @eveningly

Cron patterns of the kind `*/n' have a weakness that they only specify jumps
within their sequence.  For example the 'day' pattern `*/15' will trigger on
1st, 16th, 31st January and then again on 1st February; the pattern resets at
the end of its sequence (month days).  This might not be what you expect or
want, so we also have yearday patterns.  These have the same behaviour, but
because they don't reset till the end of the year, they get closer to what
people expect.

  00 00 00  *  * :*/2  # every two days through the year
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md doc
%perl_vendor_privlib/M*

%changelog
