# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Mojolicious.pm) perl(Test/Exception.pm) perl(URI.pm)
# END SourceDeps(oneline)
%define module_name Mojo-CouchDB
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0
Release: alt1
Summary: CouchDB the Mojo way
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RA/RAWLEYFOW/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Mojo::CouchDB;

    # Create a CouchDB instance
    my $couch = Mojo::CouchDB->new('http://localhost:6984', 'username', 'password');
    my $db = $couch->db('books');

    $db->create_db; # Create the database on the server

    # Make a document
    my $book = {
        title => 'Nineteen Eighty Four',
        author => 'George Orwell'
    };

    # Save your document to the database
    $book = $db->save($book);

    # If _id is assigned to a hashref, save will update rather than create
    say $book->{_id}; # Assigned when saving or getting
    $book->{title} = 'Dune';
    $book->{author} = 'Frank Herbert'

    # Re-save to update the document
    $book = $db->save($book);

    # Get the document as a hashref
    my $dune = $db->get($book->{_id});

    # You can also save many documents at a time
    my $books = $db->save_many([{title => 'book', author => 'John'}, { title => 'foo', author => 'bar' }])->{docs};

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE
%perl_vendor_privlib/M*

%changelog
