# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(File/ShareDir.pm) perl(Module/Build/Tiny.pm) perl(Mojolicious.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Mojo-File-Share
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Better local share directory support with Mojo::File
Group: Development/Perl
License: perl
URL: https://github.com/srchulo/Mojo-File-Share

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SR/SRCHULO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Mojo::File::Share manpage is a dropin replacement for the File::ShareDir manpage based on the File::Share manpage. the Mojo::File::Share manpage has
three main differences from the File::Share manpage:

=over 4

=item

the dist_dir entry elsewhere in this document and the dist_file entry elsewhere in this document both return the Mojo::File manpage objects.

=item

the dist_dir entry elsewhere in this document and the dist_file entry elsewhere in this document have been enhanced even more to understand when the developer's
local `./share/' directory should be used.

the File::Share manpage checks `%%INC' to determine if the dist has been `use'd or `require'd, and then it checks for the
`share' directory relative to the dist's `.pm' file location. This is good for a lot of local development, but it
is not good for using in tests if you want to access the `share' directory but haven't loaded the dist.
the Mojo::File::Share manpage does the above check, and then if that doesn't work, it checks the current working
directory for the existence of `lib/$path_to_dist.pm' and the existence of a `share' directory, and
returns that `share' directory if both conditions are true. This removes the need a lot of the time to
do something like this in your tests:

  $File::ShareDir::DIST_SHARE{'Foo-Bar'} = path('share')->realpath;

=item

If no dist is provided to the dist_dir entry elsewhere in this document or the dist_file entry elsewhere in this document, the Mojo::File::Share manpage will default to using
the calling package as the dist.

=back

NOTE: `module_dist' and `module_file' are not supported.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE
%perl_vendor_privlib/M*

%changelog
