%define module_name Mojo-IRC
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(IRC/Utils.pm) perl(List/Util.pm) perl(Mojolicious.pm) perl(Parse/IRC.pm) perl(Test/More.pm) perl(Unicode/UTF8.pm)
# END SourceDeps(oneline)
Epoch: 1
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.47
Release: alt1
Summary: IRC Client for the Mojo IOLoop
Group: Development/Perl
License: artistic_2
URL: https://github.com/jhthorsen/mojo-irc

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JH/JHTHORSEN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Mojo::IRC manpage is a non-blocking IRC client using the Mojo::IOLoop manpage from the
wonderful the Mojolicious manpage framework.

If features IPv6 and TLS, with additional optional modules:
the IO::Socket::IP manpage and the IO::Socket::SSL manpage.

By default this module will only emit standard IRC events, but by
settings the parser entry elsewhere in this document to a custom object it will also emit CTCP events.
Example:

  my $irc = Mojo::IRC->new;
  $irc->parser(Parse::IRC->new(ctcp => 1);
  $irc->on(ctcp_action => sub {
    # ...
  });

It will also set up some default events: the ctcp_ping entry elsewhere in this document, the ctcp_time entry elsewhere in this document,
and the ctcp_version entry elsewhere in this document.

This class inherit from the Mojo::EventEmitter manpage.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes README doc
%perl_vendor_privlib/T*
%perl_vendor_privlib/M*

%changelog
