%define module_name Mojo-Redis2
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Mojolicious.pm) perl(Protocol/Redis.pm) perl(Sort/Versions.pm) perl(Test/More.pm) perl(Time/HiRes.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.36
Release: alt1
Summary: Pure-Perl non-blocking I/O Redis driver
Group: Development/Perl
License: artistic_2
URL: https://github.com/jhthorsen/mojo-redis2

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JH/JHTHORSEN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Mojo::Redis2 manpage is a pure-Perl non-blocking I/O Redis
driver for the the Mojolicious manpage real-time framework.

=over

Redis is an open source, BSD licensed, advanced key-value cache and store.
It is often referred to as a data structure server since keys can contain
strings, hashes, lists, sets, sorted sets, bitmaps and hyperloglogs.
- http://redis.io.

=back

Features:

=over 4

=item * Blocking support

the Mojo::Redis2 manpage support blocking methods. NOTE: Calling non-blocking and
blocking methods are supported on the same object, but might create a new
connection to the server.

=item * Error handling that makes sense

the Mojo::Redis manpage was unable to report back errors that was bound to an operation.
the Mojo::Redis2 manpage on the other hand always make sure each callback receive an
error message on error.

=item * One object for different operations

the Mojo::Redis manpage had only one connection, so it could not do more than on
blocking operation on the server side at the time (such as BLPOP,
SUBSCRIBE, ...). This object creates new connections pr. blocking operation
which makes it easier to avoid "blocking" bugs.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_privlib/M*

%changelog
