%define module_name Mojo-Server-DaemonControl
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Mojolicious.pm) perl(Test2/V0.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: A Mojolicious daemon manager
Group: Development/Perl
License: artistic_2
URL: https://github.com/jhthorsen/mojo-server-daemoncontrol

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JH/JHTHORSEN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Mojo::Server::DaemonControl manpage is not a web server. Instead it manages one or
more the Mojo::Server::Daemon manpage processes that can handle web requests. Each of
these servers are started with SO_REUSEPORT
enabled.

This means it is only supported on systems that support
SO_REUSEPORT. It also does not support fork
emulation. It should work on most modern Linux based systems though.

This server is an alternative to the Mojo::Server::Hypnotoad manpage where each of the
workers handle long running (WebSocket) requests. The main difference is that a
hot deploy will simply start new workers, instead of restarting the manager.
This is useful if you need/want to deploy a new version of your server during
the the graceful_timeout entry elsewhere in this document. Normally this is not something you would need, but in
some cases where the graceful timeout and long running requests last for
several hours or even days, then it might come in handy to let the old
code run, while new processes are deployed.

Note that the Mojo::Server::DaemonControl manpage is currently EXPERIMENTAL and it has
not been tested in production yet. Feedback is more than welcome.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/M*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
