%define module_name Mojo-WebService-Twitter
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(File/Spec.pm) perl(IO/Socket/SSL.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Module/Build/Tiny.pm) perl(Module/Metadata.pm) perl(Mojolicious.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Time/Piece.pm) perl(WWW/OAuth.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.003
Release: alt1
Summary: Simple Twitter API client
Group: Development/Perl
License: artistic_2
URL: https://github.com/Grinnz/Mojo-WebService-Twitter

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DB/DBOOK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Mojo::WebService::Twitter manpage is a the Mojo::UserAgent manpage based
Twitter API client that can perform requests
synchronously or asynchronously. An API key and secret for a
Twitter Application are required.

API requests are authenticated by the the section on "authentication" coderef, which can
either use an OAuth 2.0 access token to authenticate requests on behalf of the
application itself, or OAuth 1.0 credentials (access token and secret) to
authenticate requests on behalf of a specific user. The the twitter_oauth_creds manpage
script can be used to obtain Twitter OAuth credentials for a user from the
command-line. A web application may wish to implement its own OAuth
authorization flow, passing a callback URL back to the application in
the section on "request_oauth", then calling the section on "verify_oauth" with the passed verifier
code to retrieve the credentials. See the
Twitter documentation for
more details.

All methods which query the Twitter API can be called with an optional trailing
callback argument to run a non-blocking API query. On transport, HTTP, or API
error, blocking API queries will throw a the Mojo::WebService::Twitter::Error manpage
exception, while non-blocking API queries will pass the exception object to the
callback. Consider organizing complex sequences of non-blocking queries with
the section on "delay" in the Mojo::IOLoop manpage.

Note that this distribution implements only a subset of the Twitter API.
Additional features may be added as requested.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CONTRIBUTING.md LICENSE README Changes
%perl_vendor_privlib/M*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
