%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(FindBin.pm) perl(IO/Handle.pm) perl(IO/Pipe.pm) perl(Mojo/Base.pm) perl(Mojo/IOLoop.pm) perl(Mojo/Log.pm) perl(POSIX.pm) perl(Scalar/Util.pm) perl(Storable.pm) perl(Symbol.pm) perl(Test/More.pm) perl(Time/HiRes.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.15
%define module_name MojoX-Run
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.15
Release: alt1
Summary: asynchronous external command and subroutine execution for Mojo
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BF/BFG/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
# create async executor SINGLETON object
 my $mojox_run = MojoX::Run->singleton();
 
 # simple usage
 my $pid = $mojox_run->spawn(
 _cmd => "ping -W 2 -c 5 host.example.org",
 _exit_cb => sub {
 __my ($pid, $res) = @_;
 __print "Ping finished with exit status $res->{exit_val}.\n";
 __print "\tSTDOUT:\n$res->{stdout}\n";
 __print "\tSTDERR:\n$res->{stderr}\n";
 _}
 );
 # check for injuries
 unless ($pid) {
 _print "Command startup failed: ", $mojox_run->error(), "\n";
 }
 
 # more complex example...
 my $pid2 = $mojox_run->spawn(
 _cmd => 'ping -W 2 -c 5 host.example.org',
 _stdin_cb => sub {
 __my ($pid, $chunk) = @_;
 __print "STDOUT $pid: '$chunk'\n"
 _},
 _# ignore stderr
 _stderr_cb => sub {},
 _exit_cb => sub {
 __my ($pid, $res) = @_;
 __print "Process $res->{cmd} [pid: $pid] finished after $res->{time_duration_exec} second(s).\n";
 __print "Exit status: $res->{exit_status}";
 __print " by signal $res->{exit_signal}" if ($res->{exit_signal});
 __print " with coredump." if ($res->{exit_core});
 __print "\n";
 _}
 );
 
 # even fancier usage: spawn coderef
 my $pid3 = $mojox_run->spawn(
 _cmd => sub {
 __for (my $i = 0; $i < 10; $i++) {
 ___if (rand() > 0.5) {
 ____print STDERR rand(), "\n"
 ___} else {
 ____print rand(), "\n";
 ___}
 ___sleep int(rand(10));
 __}
 __exit (rand() > 0.5) ? 0 : 1;
 _},
 _exit_cb => {
 __print "Sub exited with $res->{exit_status}, STDOUT: $res->{stdout}\n";
 _},
 );


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/M*

%changelog
