%define module_name MojoX-UserAgent-Throttler
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Module/Build/Tiny.pm) perl(Mojo/Base.pm) perl(Mojo/UserAgent.pm) perl(Mojo/Util.pm) perl(Mojolicious.pm) perl(Sub/Throttler.pm) perl(Sub/Throttler/Limit.pm) perl(Sub/Util.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(ojo.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0.3
Release: alt1
Summary: add throttling support to Mojo::UserAgent
Group: Development/Perl
License: mit
URL: https://github.com/powerman/perl-MojoX-UserAgent-Throttler

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PO/POWERMAN/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This module helps throttle the Mojo::UserAgent manpage using the Sub::Throttler manpage.

While in most cases this module isn't needed and existing functionality of
Sub::Throttler is enough to throttle Mojo::UserAgent, there are two
special cases which needs extra handling - when Mojo::UserAgent object
is destroyed while there are delayed requests, and when new async
requests start while destroying Mojo::UserAgent object.

To handle these cases it won't be enough to just do usual:

    throttle_it('Mojo::UserAgent::start');

Instead you'll have to write the section on "custom wrapper" in the Sub::Throttler manpage plus add
wrapper for Mojo::UserAgent::DESTROY. Both are provided by this module and
activated when you load it.

So, when using this module you shouldn't manually call throttle_it() like
shown above - just use this module and then setup throttling algorithms as
you need and apply them to the section on "start" in the Mojo::UserAgent manpage - this will let you
throttle all (sync/async, GET/POST/etc.) requests.
Use the section on "apply_to" in the Sub::Throttler::algo manpage to customize throttling based on
request method, hostname, etc.


%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/M*

%changelog
