%define module_name Mojolicious-Plugin-CSRF
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Crypt/URandom.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Mojo/Base.pm) perl(Mojo/DOM.pm) perl(Mojo/Util.pm) perl(Mojolicious/Lite.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/EOL.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Portability/Files.pm) perl(Test/Synopsis.pm) perl(Test2/MojoX.pm) perl(Test2/V0.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.05
Release: alt1
Summary: Cross Site Request Forgery (CSRF) "prevention" Mojolicious plugin
Group: Development/Perl
License: artistic_2
URL: https://github.com/gryphonshafer/Mojo-Plugin-CSRF

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GR/GRYPHON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is a the Mojolicious manpage plugin for Cross Site Request Forgery (CSRF)
"prevention" (theoretically; if used correctly; caveat emptor).

By default, when used, the plugin will cause requests methods that traditionally
contain data-changing actions (i.e. POST, PUT, etc.) to check a generated session
token against a token from a form value, URL parameter, or HTTP header. On
failure, a the Mojo::Exception manpage is thrown.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README SECURITY.md
%perl_vendor_privlib/M*

%changelog
