%define module_name Mojolicious-Plugin-CustomLog
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Fcntl.pm) perl(Mojo/Base.pm) perl(Mojo/Util.pm) perl(Mojolicious/Lite.pm) perl(Test/Mojo.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt2
Summary: A custom logger that can output log by date and type
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/W/WJ/WJX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Provides custom log utilities that can output log by date and type

    use Mojolicious::Plugin::CustomLog;

    sub startup {
        my $self = shift;

        $self->plugin('CustomLog', {
                "path" => {
                    "test"   => "log/test"   # relative to home directory of app
                    "check"  => "log/check"
                },
                "helper" => "mylog",
                "alias"  => "Global"
            });

        # using app helper
        $self->mylog->debug('test',  "this is test log");

        # using alias
        Global::CLog->error('check', "this is error log");
    }

%prep
%setup -q -n %{module_name}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Readme.md
%perl_vendor_privlib/M*

%changelog
