# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/perldoc perl(ExtUtils/MakeMaker.pm) perl(Mojo/Base.pm) perl(Mojo/Util.pm) perl(Mojolicious.pm) perl(Mojolicious/Lite.pm) perl(Scalar/Util.pm) perl(Test/Mojo.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.04
%define module_name Mojolicious-Plugin-DomIdHelper
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Mojolicious plugin to generate DOM IDs and CSS class names from your ORM objects
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SH/SHAW/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
DOM IDs are generated by joining an object's package name and its primary key with the character 
specified by the the delimiter entry elsewhere in this document option. By default the primary key is retrieved via a method 
named `id'. This can be modified, see the OPTIONS entry elsewhere in this document.

By default, given an instance of `DB::Package::User' with an ID of `1':

  dom_id($user)
  dom_class($user)

will generate:

  user_1 
  user

For `dom_id', if the primary key is undefined only the package name is returned. 
If `$user' is not a reference `undef' is returned.

Multi-column primary keys are not separated by the the delimiter entry elsewhere in this document option, they are concatenated.

For references that aren't blessed `dom_id' and `dom_class' return the reference type. 
If Lingua::EN::Inflect is installed array references that contain a blessed reference will return 
the pluralized form of the blessed reference. 

For example, if Lingua::EN::Inflect is installed:

  dom_id([$user])
  dom_class([$user])
  dom_id([])
  dom_id({ user => $user })
  dom_id({})
  
will generate:
  
  users
  users
  array
  hash
  hash
  
If Lingua::EN::Inflect is not installed `dom_id([$user])' will return `array'.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.pod
%perl_vendor_privlib/M*

%changelog
