%define module_version 1.000001
%define module_name Mojolicious-Plugin-ExposeControllerMethod
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Spec.pm) perl(File/Spec/Functions.pm) perl(Mojo/Base.pm) perl(Pod/Coverage/TrustPod.pm) perl(Pod/Wordlist.pm) perl(Test/CPAN/Changes.pm) perl(Test/EOL.pm) perl(Test/Mojo.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Spelling.pm) perl(Test/Version.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.000001
Release: alt1
Summary: expose controller method
Group: Development/Perl
License: perl
URL: http://metacpan.org/release/Mojolicious-Plugin-ExposeControllerMethod/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MAXMIND/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Exposes *selected* methods from the current controller to Mojolicious templates
via the `ctrl' helper.

In order to expose methods to Mojolicious templates your controller must
implement the `controller_method_name' method which will be passed the name of
the method Mojolicious wishes to call on the controller.  This method should
return either false (if the method cannot be called), or the name the method
that should be called ( which is probably the same as the name of the method
passed in.)

For example:

  package MyApp::Controller::Example;
  use Mojo::Base 'Mojolicious::Controller';

  sub name           { return "Mark Fowler" }
  sub any_other_name { return "Still smells sweet" }
  sub reverse        { my $self = shift; return scalar reverse join '', @_ }

  sub controller_method_name {
      my $self = shift;
      my $what = shift;

      return $what if $what =~ /\A(test1|reverse)\z/;
      return 'any_other_name' if $what eq 'rose';
      return;
  }

  ...

The results of `controller_method_name' are expected to be consistent for
a given Mojolicious Controller class for a given method name (this module
is optimized on this assumption, caching method name calculations.)
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md
%perl_vendor_privlib/M*

%changelog
