# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN/Uploader.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(GSSAPI.pm) perl(Mojolicious.pm) perl(Net/LDAP.pm) perl(Pod/Markdown/Github.pm)
# END SourceDeps(oneline)
%define module_name Mojolicious-Plugin-GSSAPI
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.2
Release: alt1
Summary: Provide Kerberos authentication for incomming https requests
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/O/OE/OETIKER/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The `Mojolicious::Plugin::GSSAPI` plugin lets you use kerberos authentication
in your mojo app. The plugin uses
the the GSSAPI manpage module for the heavy lifting.

If you want to use kerberos to SSO in a webproxy, use the web_proxy_mode option:

 plugin 'GSSAPI',web_proxy_mode => 1;

The included example script gssapi-demo.pl shows how to use the plugin
to implement Kerberos SSO authentication for a the Mojolicious::Lite manpage web application.

If your machine is not yet part of the AD Domain, get it added to the ad server especially the dns entry including reveres lookup is important.

Then, make sure the /etc/resolv.conf or /etc/systemd/resolved.conf points to your ad server.

For some reason it seems best to have the ad server also added to your /etc/hosts file.

Add the ad `realm` to the /etc/krb5.conf file

 [libdefaults]
    default_realm = MY-AD.DOMAIN

Now use the `adcli` tool to join the AD domain and add a `http` service entry.


 adcli join \
    --login-type user \
    --login-user Administrator \
    --domain-controller adserver.my-ad.domain \
    --service-name http


If you do not have the Administrator password for your AD server, you may also get a 'one-time-password' from your friendly ad admin person to join your machine to the AD domain.

And now about actually testing the plugin: 

 $ perl Makefile.PL
 $ make 3rd
 $ sudo ./eg/gssapi-demo.pl deamon


The sudo in the example above is necessary for the app to be able to read information from the /etc/krb5.keytab. You could also provide the demo with a copy of the file and use export KRB5CCNAME=/opt/demo/my.keytab to tell the demo where to find the keytab file.

For your browser todo kerberos sso, you will have to let it know that your test machine is part of the 'realm'. On windows this is done by adding the name of your linux box to "Internet Properties -> Security -> Local intranet -> Sites -> Advanced"

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE
%perl_vendor_privlib/M*

%changelog
