# BEGIN SourceDeps(oneline):
BuildRequires: perl(DDP.pm) perl(FindBin.pm) perl(GD.pm) perl(Module/Build/Tiny.pm) perl(Mojolicious.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(YAML/XS.pm)
# END SourceDeps(oneline)
%define module_name Mojolicious-Plugin-Gallery
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: Simple photo gallery for Mojolicious
Group: Development/Perl
License: perl
URL: https://github.com/sklukin/Mojolicious-Plugin-Gallery

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SK/SKLUKIN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Mojolicious::Plugin::Gallery use if you want to create simple gallery

Exampler content main.conf

  {
    gallery => {
      main_path => 'public/gallery',
      sizes => {
        thumbnail => {
          width   => 412,
          height  => 412,
          crop    => 1,
          quality => 85
        },
        medium => {
          width   => 800,
          height  => 550,
          crop    => 0,
          quality => 90
        },
        large => {
          width   => 1200,
          height  => 800,
          crop    => 0,
          quality => 90
        }
      }
    },
  }


example app.pl

  #!/usr/bin/env perl

  use lib 'lib';
  use Mojolicious::Lite;

  app->plugin(Config => { file => 'main.conf' });

  app->plugin('Gallery');

  get '/' => sub {
    my $c = shift;

    $c->render(text => '<a href="/gallery">Gallery</a>');
  };

  app->start;

Also you can find example app on https://github.com/sklukin/Mojolicious-Plugin-Gallery

Your steps for create new photo gallery

  - Make dir in public/gallery
  - Run ./cmd.pl resize
  - Update info in public/gallery/<your album>/meta.yml
  - Restart your app

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/M*
%perl_vendor_privlib/C*

%changelog
