%define module_name Mojolicious-Plugin-Google-Cloud-UserAgent
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Mojo/JWT/Google.pm) perl(Mojolicious.pm) perl(Mojo/JWT.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt2
Summary: A user agent for GCP
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SC/SCOTTW/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Mojolicious::Plugin::Google::Cloud::UserAgent manpage is a the Mojolicious manpage
plugin for interacting with Google Cloud Platform. It performs
2-legged OAuth described here:
https://cloud.google.com/docs/authentication.

First, create a service account key:

https://console.cloud.google.com/apis/credentials?project=your-project

Download this JSON file; you may hard-code the path to the JSON
service account key file when you load this plugin, or set an
environment variable, etc.

Next, determine the proper scopes for the user agent. Each GCP API has
a section in its documentation describing the scopes required to
invoke the API. For example, here is the Logging API scopes:

https://cloud.google.com/logging/docs/api/tasks/authorization

Once you have these two items, pass them to the plugin as
configuration:

   plugin 'Google::Cloud::UserAgent' => {
     gcp_auth_file => $ENV{GCP_AUTH_FILE},
     scopes        => ['https://www.googleapis.com/auth/logging.write',
                       'https://www.googleapis.com/auth/logging.read'],
   };

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md
%perl_vendor_privlib/M*

%changelog
