%define module_name Mojolicious-Plugin-Narada
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Module/Build/Tiny.pm) perl(Mojo/Base.pm) perl(MojoX/Log/Fast.pm) perl(Mojolicious.pm) perl(Narada.pm) perl(Narada/Config.pm) perl(Narada/Lock.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0.1
Release: alt1
Summary: Narada configuration plugin
Group: Development/Perl
License: mit
URL: https://github.com/powerman/perl-Mojolicious-Plugin-Narada

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PO/POWERMAN/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
the Mojolicious::Plugin::Narada manpage is a plugin that configure the Mojolicious manpage
to work in the Narada manpage project management environment.

Also this plugin add helper `proxy', and you MUST
use it to wrap all callbacks you setup for handling delayed events like
timers or I/O (both global in your app and related to requests in your
actions).

There is also one feature unrelated to Narada - if callback started by any
action throw unhandled exception it will be sent to browser using same
`$c->render_exception' as it already works for actions without
delayed response.

=over

=item Logging

the Mojolicious manpage default the Mojo::Log manpage replaced with the MojoX::Log::Fast manpage to
support logging to project-local syslog daemon in addition to files.
In most cases it works as drop-in replacement and doesn't require any
modifications in user code.

Also it set `$app->log->indent()' to `$c->req->url->path' to
ease log file analyse.

=item Configuration

You should manually add these lines to `./you_app' starting script before
call to `Mojolicious::Commands->start_app()':

    use Narada::Config qw( get_config_line );
    # mode should be set here because it's used before executing MyApp::startup()
    local $ENV{MOJO_MODE} = get_config_line('mode');

Config file `config/cookie.secret' automatically loaded and used to
initialize `$app->secrets()'.

Config file `config/basepath' automatically loaded and used to fix
`$c->req->url->base->path' and `$c->req->url->path' to
guarantee their consistency in any environment:

=over

=item * url->path doesn't contain base->path

=item * url->path does have leading slash

=item * url->base->path set to content of config/basepath

=back


These config files automatically loaded from `config/hypnotoad/*'
and used to initialize `$app->config(hypnotoad)':

    listen
    proxy
    accepts
    workers

Also hypnotoad configured to keep it lock/pid files in `var/'.

=item Locking

`unlock()' will be automatically called after all actions and callbacks,
even if they throw unhandled exception.

=back
%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/M*

%changelog
