%define module_name Mojolicious-Plugin-RelativeUrlFor
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Mojolicious.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.052
Release: alt2
Summary: relative links in Mojolicious, really.
Group: Development/Perl
License: MIT-LICENSE
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/ME/MEMOWE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This Mojolicious plugin adds a new helper to your web app: `relative_url_for',
together with its short alias `rel_url_for'. Mojo's URL objects already had a
method for this before 4.90, but to get really relative URLs like *../foo.html*
you had to add the request url like this:

    my $url     = $self->url_to('foo', bar => 'baz');
    my $rel_url = $url->to_rel($self->req->url);

The new helper method gets the job done for you:

    my $rel_url = $self->rel_url_for('foo', bar => 'baz');

Generated URLs are always relative to the request url.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes MIT-LICENSE
%perl_vendor_privlib/M*

%changelog
