%define module_name Mojolicious-Plugin-Restify
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Mojolicious.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: Route shortcuts & helpers for REST collections
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KW/KWAKWA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Mojolicious::Plugin::Restify manpage is a the Mojolicious::Plugin manpage. It simplifies
generating all of the the Mojolicious::Routes manpage for a typical REST *collection*
endpoint (e.g., `/accounts' or `/invoices') and maps the common HTTP verbs
(`DELETE', `GET', `PATCH', `POST', `PUT') to underlying controller class
methods.

For example, creating a *collection* called `/accounts' would create the
routes as shown below. N.B. The `over' option in the example below corresponds
to the name of a route condition. See the conditions entry in the Mojolicious::Routes manpage.

  # The collection route shortcut below creates the following routes, and maps
  # them to controllers of the camelized route's name.
  #
  # /accounts           *         accounts
  #   +/                GET       "accounts_list"       Accounts::list
  #   +/                POST      "accounts_create"     Accounts::create
  #   +/:accounts_id    *         "accounts"
  #     +/              *         "accounts_under"      Accounts::under
  #       +/            DELETE    "accounts_delete"     Accounts::delete
  #       +/            GET       "accounts_read"       Accounts::read
  #       +/            PATCH     "accounts_patch"      Accounts::patch
  #       +/            PUT       "accounts_update"     Accounts::update

  # expects the element id (:accounts_id) for this collection to be a uuid
  my $route = $r->collection('accounts', over => 'uuid');

the Mojolicious::Plugin::Restify manpage tries not to make too many assumptions, but the
author's recent experience writing a REST-based API using the Mojolicious manpage has
helped shaped this plugin, and might unwittingly express some of his bias.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md
%perl_vendor_privlib/M*

%changelog
