%define module_name Mojolicious-Plugin-SOAP-Server
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI.pm) perl(CPAN/Uploader.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Mojo/SOAP/Client.pm) perl(Mojolicious.pm) perl(Pod/Markdown/Github.pm) perl(XML/Compile/SOAP.pm) perl(XML/Compile/SOAP/Daemon.pm) perl(XML/Compile/SOAP12.pm) perl(XML/Compile/WSDL11.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.6
Release: alt1
Summary: Hook a SOAP Server into your regular mojolicious server
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/O/OE/OETIKER/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The the Mojolicious::Plugin::SOAP::Server manpage is a thin wrapper around the XML::Compile::SOAP::Daemon manpage which makes it pretty simple to implement SOAP services in perl.

The plugin supports the following configuration options:

=over

=item wsdl

A wsdl filename with definitions for the services provided

=item xsds

An array pointer with xsd files for the data types used in the wsdl.

=item controller

A mojo Object whose methods match the service names defined in the wsdl file.

 sub methodName ($self,$server,$params,$controller) {

see example folder for inspiration.

=item default_cb

A default callback to be called if the requested method does not exist in the controller.

=item endPoint

Where to 'mount' the SOAP service.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE CHANGES README.md example
%perl_vendor_privlib/M*

%changelog
