%define module_name Mojolicious-Plugin-SPNEGO
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN/Uploader.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Socket/Timeout.pm) perl(Mojolicious.pm) perl(Net/LDAP/SPNEGO.pm) perl(Pod/Markdown/Github.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.5.4
Release: alt1
Summary: Provide NTLM authentication by forwarding requests to an upstram AD server
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/O/OE/OETIKER/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
# Mojolicious::Plugin::SPNEGO

```perl
use Mojolicious::Lite;

my $SERVER = $ENV{AD_SERVER} // die "AD_SERVER env variable not set";

app->secrets(['My secret passphrase here']);

plugin 'SPNEGO', ad_server => $SERVER;

get '/' => sub {
   my $c = shift;

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/M*

%changelog
