# BEGIN SourceDeps(oneline):
BuildRequires: perl(Compress/Zlib.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Mojo/Base.pm) perl(Mojo/JSON.pm) perl(Mojo/Util.pm) perl(Mojolicious/Lite.pm) perl(Test/Mojo.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Mojolicious-Plugin-SessionCompress
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Session serialization and compression plugin for Mojolicious
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SO/SOHASHI/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
# Default settings

    plugin 'SessionCompress';

    # Custom settings

    use Compress::Zlib qw(deflateInit inflateInit Z_STREAM_END);
    use Data::Dumper 'Dumper';
    $Data::Dumper::Terse = 1;

    plugin session_compress => {
      compress => sub {
        my $string = shift;

        my $d = deflateInit(-Level => 1, -memLevel => 4, -WindowBits => -15);
        return $d->deflate($string) . $d->flush;
      },
      decompress => sub {
        my $string = $_[0];

        my $d = inflateInit(-WindowBits => -15);
        my ($inflated, $status) = $d->inflate($string);
        # Check to see if it's actually compressed
        return $_[0] if $status != Z_STREAM_END || length($inflated) <= 1;
        return $inflated;
      },
      serialize => sub {
        my $hashref = shift;

        return Dumper($hashref);
      },
      deserialize => sub {
        my $string = shift;

        return eval $string;
      },
      min_size => 100
    };
%prep
%setup -n %{module_name}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md
%perl_vendor_privlib/M*

%changelog
