%define module_name Mojolicious-Plugin-Subdispatch
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Mojolicious.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt2
Summary: create requests to your Mojolicious actions
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/ME/MEMOWE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This Mojolicious plugin creates a `subdispatch` helper, which helps you
creating a request for your actions, and returns the response object with
your fully rendered HTML content.

The interface has some similarities to Mojo::UserAgent:
just use your request method (DELETE, GET, HEAD, POST, PUT) as the method name
and pass the same arguments as you would do for `url_for`:

To build a post request with data, append the data hash at the end:

    my $res = app->subdispatch->post('route', foo => 'bar', {with => 'data'});

If you want to access the transaction object around the response, use the
subdispatch helper with arguments like this:

    my $tx = app->subdispatch(GET  => 'route', foo => 'bar');
    my $tx = app->subdispatch(POST => 'route', foo => 'bar', {with => 'data'});

For some reasons, it seamed important to me to be able to set the base url of
the resulting requests, so this is possible via

    plugin 'Subdispatch', base_url => 'http://example.org';

This is an early version and may change without warning. I'll use it to create
static HTML pages from a Mojolicious blog, but if you find another good way
to use it, please let me know!

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/M*

%changelog
