%define module_name Mojolicious-Plugin-TemplateToolkit
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/Method/Modifiers.pm) perl(File/Spec.pm) perl(Module/Build.pm) perl(Module/Build/Tiny.pm) perl(Module/Metadata.pm) perl(Mojolicious.pm) perl(Scalar/Util.pm) perl(Template.pm) perl(Template/Provider.pm) perl(Test/More.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.006
Release: alt1
Summary: Template Toolkit renderer plugin for Mojolicious
Group: Development/Perl
License: artistic_2
URL: https://github.com/Grinnz/Mojolicious-Plugin-TemplateToolkit

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DB/DBOOK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Mojolicious::Plugin::TemplateToolkit manpage is a renderer for `tt2' or
`Template Toolkit' templates. See the Template manpage and the Template::Manual manpage for
details on the `Template Toolkit' format, and the Mojolicious::Guides::Rendering manpage
for general information on rendering in the Mojolicious manpage.

the Mojolicious manpage helpers and stash values will be exposed directly as
variables in the templates, and the current
controller object will be available as `c' or `self', similar to
the Mojolicious::Plugin::EPRenderer manpage. See the Mojolicious::Plugin::DefaultHelpers manpage
and the Mojolicious::Plugin::TagHelpers manpage for a list of all built-in helpers.

 $c->stash(description => 'template engine');
 $c->stash(engines => [qw(Template::Toolkit Text::Template)]);
 
 [%% FOREACH engine IN engines %%]
   [%% engine %%] is a [%% description %%].
 [%% END %%]
 
 [%% link_to('Template Toolkit', 'http://www.template-toolkit.org') %%]
 
 [%% c.param('foo') %%]


Along with standard template files, inline and data section templates can be
rendered in the standard way. Template files and data sections will be
retrieved using the Mojolicious::Renderer manpage via the Template::Provider::Mojo manpage for
both standard rendering and directives such as `INCLUDE'. This means that
instead of specifying INCLUDE_PATH,
you should set the section on "paths" in the Mojolicious::Renderer manpage to the appropriate paths.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes CONTRIBUTING.md README LICENSE
%perl_vendor_privlib/M*
%perl_vendor_privlib/T*

%changelog
