%define module_name Mojolicious-Static-Role-Compressed
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Method/Modifiers.pm) perl(FindBin.pm) perl(Module/Build/Tiny.pm) perl(Mojolicious.pm) perl(Role/Tiny.pm) perl(Scalar/Util.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Warn.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Role for Mojolicious::Static that serves pre-compressed versions of static assets
Group: Development/Perl
License: perl
URL: https://github.com/srchulo/Mojolicious-Static-Role-Compressed

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SR/SRCHULO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Mojolicious::Static::Role::Compressed manpage is a role for the Mojolicious::Static manpage
that provides the ability to serve pre-compressed versions of static asset.
the Mojolicious::Static::Role::Compressed manpage does this by using the before method
modifier on the serve_asset entry in the Mojolicious::Static manpage and
the is_fresh entry in the Mojolicious::Static manpage. A static asset will be served when all of the
following conditions are met:

=over 4

=item *

The asset passed to the serve_asset entry in the Mojolicious::Static manpage is a
the Mojo::Asset::File manpage (the is_file entry in the Mojo::Asset manpage returns `1').

=item *

It is determined that the asset should be served by the should_serve_asset entry elsewhere in this document
being a true scalar value or a subroutine that returns true for the given
the Mojo::Asset::File manpage.

=item *

the accept_encoding entry in the Mojo::Headers manpage for the request contains at least one encoding
listed in the compression_types entry elsewhere in this document.

=item *

A compressed version of the asset is found that is smaller than the original
asset. Assets are expected to be located at the path of the original asset,
followed by a period and the extension: `/path/to/asset.css' ->
`/path/to/asset.css.gz'

=back

the Mojolicious::Static::Role::Compressed manpage uses the same modified time as the
original asset when setting the last_modified entry in the Mojo::Headers manpage in the response, and
modifies the ETag (the etag entry in the Mojo::Headers manpage) in the response by appending
`"-$encoding"' (i.e. "etag-gzip"), where the encoding is specified in
the compression_types entry elsewhere in this document. This is in line with
RFC-7232, which explicitly
states that ETags should be content-coding aware.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/M*

%changelog
