# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Moo.pm) perl(strictures.pm)
# END SourceDeps(oneline)
%define module_name MooX-EventHandler
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.000
Release: alt1
Summary: Use Moo modules with event handlers.
Group: Development/Perl
License: see LICENSE
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CH/CHOHAG/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Exports a function `has_event' which creates an attribute with
settings useful for writing event-driven code.

Specifically:

=over

=item * Event attributes are lazy by default.

=item * The attribute is named `_${event}_event' so that `$event()'
calls the event handler rather than returning the coderef which
implements it. The `init_arg' remains `$event' and the default
builder `_build_$event'.

=item * `required' now means that the default event handler will die,
not that a handler must be passed to the constructor.

=item * (Optionally) Another attribute is added to the class which
returns a listref of this object's event.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE
%perl_vendor_privlib/M*

%changelog
