%define module_name MooX-LazierAttributes
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Clone.pm) perl(ExtUtils/MakeMaker.pm) perl(Module/Metadata.pm) perl(Moo.pm) perl(Moo/Role.pm) perl(MooX/ReturnModifiers.pm) perl(Moose.pm) perl(Test/More.pm) perl(Test/Requires.pm) perl(Type/Tiny.pm) perl(Types/Standard.pm) perl(constant.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.07010
Release: alt1
Summary: Lazier Attributes.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LN/LNATION/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
package Hello::World;
    
    use Moo;
    use MooX::LazierAttributes;

    attributes (
        one   => [], # defaults to be ro
        two   => [{}],
        three => [sub { My::Thing->new() }, { lzy, }],
        [qw/four five six/] => [rw, 'ruling the world'],
    );

    has seven => ( is_ro, lzy, default => sub { [qw/a b c/] });

    .....

    my $hello = Hello::World->new({ 
        one => 1,
        two => { three => 'four' },   
    });

    $hello->one;    # 1
    $hello->two;    # { three => 'four' }
    $hello->three;  # $obj

    ... Extending .....

    package Extends::Hello::World;

    use Moo;
    use MooX::LazierAttributes;

    extends 'Hello::World';
    
    attributes (
        '+one' => ['hey'],
        '+two' => [[qw/why are you inside/]],
        [qw/+four +five +six/] => ['well the sun it hurts my eyes'],
    );

    my $hello = Extends::Hello::World->new();

    $hello->one;    # hey
    $hello->two;    # ['why', 'are', 'you', 'inside'],
    $hello->four;   # well the sun it hurts my eyes

    ... What if I like Types ...

    package Hello::World;
    
    use Moo;
    use MooX::LazierAttributes qw/is_ro rw lzy bld/;
    use Types::Standard qw/Str HashRef ArrayRef Object/;

    attributes (
        one   => [Str], # defaults to be ro
        two   => [HashRef],
        three => [Object, { lzy, bld }],
        [qw/four five six/] => [rw, Str, { default => 'ruling the world' }],
    );

    has seven => ( is_ro, lzy, isa => ArrayRef, default => sub { [qw/a b c/] });

    sub _build_three { 
        return My::Thing->new();
    }
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/M*

%changelog
