%define module_name MooX-Role-JSON_LD
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(JSON/MaybeXS.pm) perl(List/Util.pm) perl(MRO/Compat.pm) perl(Moo.pm) perl(Moose.pm) perl(Sub/Quote.pm) perl(Test/More.pm) perl(Types/Standard.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.0.0
Release: alt1
Summary: Easily provide JSON-LD mark-up for your objects.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DA/DAVECROSS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This role allows you to easily add a method you your class that produces
JSON-LD representing an instance of your class.

To do this, you need to do three things:

=over 4

=item 1. Add the role to your class

    with 'MooX::Role::JSON_LD';

=item 2. Add a method telling the role which JSON-LD type to use in the output

    sub json_ld_type { 'Person' }

=item 3. Add a method defining the fields you want to appear in the JSON-LD

    sub json_ld_fields { [ qw[ first_name last_name birth_date ] ] };

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes.md README.md
%perl_vendor_privlib/M*

%changelog
