# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Moo.pm) perl(Role/Tiny.pm) perl(Sub/Defer.pm) perl(Sub/Quote.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.1.2
%define module_name MooX-Role-Reconstruct
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.2
Release: alt1.1
Summary: Reconstruct Moo Objects
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BO/BOFTX/MooX/%{module_name}-v%{module_version}.tar.gz
BuildArch: noarch

%description
It is often desirable to create an object from a database row or a decoded
JSON object. However, it is quite likely that you might have declared some
attributes with `init_arg => undef' so simply calling
`class->new( %%hash )' will fail.

This module makes it possible by providing a constructor that will ignore
all `init_arg' directives. This behavior can be disabled on a case-by-case
basis by specifying `keep_init => 1' in the `has' structure for a given
attribute as shown below:

  
 has foo => (
    is => 'ro',
    default => 'bar',
    init_arg => 'baz',
    keep_init => 1,
 );
  

In this case, the noraml behavior of taking the initializer value from
`baz' if it is present will be retained.

`BUILDARGS' and `BUILD' will be called as they would be if `class->new'
had been used, as will any `coerce' and/or `isa' specifiers. (This presumes
that one has written sensible `coerce' and `isa' conditions.)
%prep
%setup -n %{module_name}-v%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes Todo
%perl_vendor_privlib/M*

%changelog
