%define module_name MooX-Struct
# BEGIN SourceDeps(oneline):
BuildRequires: perl(B/Hooks/EndOfScope.pm) perl(Data/Dumper.pm) perl(Data/Printer.pm) perl(Data/Printer/Filter.pm) perl(Exporter/Tiny.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Handle.pm) perl(Moo.pm) perl(Object/ID.pm) perl(Scalar/Util.pm) perl(Term/ANSIColor.pm) perl(Test/More.pm) perl(Type/Tiny.pm) perl(if.pm) perl(namespace/autoclean.pm) perl(namespace/clean.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.020
Release: alt1
Summary: make simple lightweight record-like structures that make sounds like cows
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/MooX-Struct

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
MooX::Struct allows you to create cheap struct-like classes for your data.using the Moo manpage.

While similar in spirit to the MooseX::Struct manpage and the Class::Struct manpage, 
MooX::Struct has a somewhat different usage pattern. Rather than providing
you with a `struct' keyword which can be used to define structs, you
define all the structs as part of the `use' statement. This means they
happen at compile time.

A struct is just an "anonymous" Moo class. MooX::Struct creates this class
for you, and installs a lexical alias for it in your namespace. Thus your
module can create a "Point3D" struct, and some other module can too, and
they won't interfere with each other. All struct classes inherit from
MooX::Struct.

Arguments for MooX::Struct are key-value pairs, where keys are the struct
names, and values are arrayrefs.

 use MooX::Struct
    Person   => [qw/ name address /],
    Company  => [qw/ name address registration_number /];

The elements in the array are the attributes for the struct (which will be
created as read-only attributes), however certain array elements are treated
specially.

=over

=item *

As per the example in the the SYNOPSIS entry elsewhere in this document, `-extends' introduces a list of
parent classes for the struct. If not specified, then classes inherit from
MooX::Struct itself.

Structs can inherit from other structs, or from normal classes. If inheriting
from another struct, then you *must* define both in the same `use' statement.
Inheriting from a non-struct class is discouraged.

 # Not like this.
 use MooX::Struct Point   => [ 'x', 'y' ];
 use MooX::Struct Point3D => [ -extends => ['Point'], 'z' ];
 
 # Like this.
 use MooX::Struct
    Point   => [ 'x', 'y' ],
    Point3D => [ -extends => ['Point'], 'z' ],
 ;

=item *

Similarly `-with' consumes a list of roles.

=item *

If an attribute name is followed by a coderef, this is installed as a
method instead.

 use MooX::Struct
    Person => [
       qw( name age sex ),
       greet => sub {
          my $self = shift;
          CORE::say "Hello ", $self->name;
       },
    ];

But if you're defining methods for your structs, then you've possibly missed
the point of them.

=item *

If an attribute name is followed by an arrayref, these are used to set the
options for the attribute. For example:

 use MooX::Struct
    Person  => [ name => [ is => 'ro', required => 1 ] ];

Using the `init_arg' option would probably break stuff. Don't do that.

=item *

Attribute names may be "decorated" with prefix and postfix "sigils". The prefix
sigils of `@' and `%%' specify that the attribute isa arrayref or
hashref respectively. (Blessed arrayrefs and hashrefs are accepted; as are
objects which overload `@{}' and `%%{}'.) The prefix sigil `$'
specifies that the attribute value must not be an unblessed arrayref or hashref.
The prefix sigil `+' indicates the attribute is a number, and provides
a default value of 0, unless the attribute is required. The postfix sigil
`!' specifies that the attribute is required.

 use MooX::Struct
    Person  => [qw( $name! @children )];

 Person->new();         # dies, name is required
 Person->new(           # dies, children should be arrayref
    name     => 'Bob',
    children => 2,
 );

=back

Prior to the key-value list, some additional flags can be given. These begin
with hyphens. The flag `-rw' indicates that attributes should be
read-write rather than read-only.

 use MooX::Struct -rw,
    Person => [
       qw( name age sex ),
       greet => sub {
          my $self = shift;
          CORE::say "Hello ", $self->name;
       },
    ];

The `-retain' flag can be used to indicate that MooX::Struct should
not use namespace::clean to enforce lexicalness on your struct class
aliases.

Flags `-trace' and `-deparse' may be of use debugging.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README NEWS CREDITS Changes LICENSE COPYRIGHT examples
%perl_vendor_privlib/M*

%changelog
