%define module_name Moonshine-Component
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Module/Metadata.pm) perl(Moonshine/Element.pm) perl(Moonshine/Magic.pm) perl(Moonshine/Test.pm) perl(Moonshine/Util.pm) perl(Params/Validate.pm) perl(Ref/Util.pm) perl(Test/More.pm) perl(UNIVERSAL/Object.pm) perl(feature.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: HTML Component base.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LN/LNATION/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
package Moonshine::Component::Glyphicon;

    use Moonshine::Util qw/join_class prepend_str/;

    extends 'Moonshine::Component';
    
    lazy_components (qw/span/)
    
    has (
        modifier_spec => sub { 
            {
                switch => 0,
                switch_base => 0,
            }
        }
    );

    sub modify {
        my $self = shift;
        my ($base_args, $build_args, $modify_args) = @_;
        if (my $class = join_class($modify_args->{switch_base}, $modify_args->{switch})){
            $base_args->{class} = prepend_str($class, $base_args->{class});
        }
        return $base_args, $build_args, $modify_args;
    }

    sub glyphicon {
        my $self = shift;
        my ( $base_args, $build_args ) = $self->validate_build(
            {
                params => $_[0] // {},
                spec => {
                    switch      => 1,
                    switch_base => { default => 'glyphicon glyphicon-' },
                    aria_hidden => { default => 'true' },
                }
            }
        );
        return $self->span($base_args);
    }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/M*

%changelog
