# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Build.pm) perl(MooseX/Role/Parameterized.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    MooseX-AlwaysCoerce
%define upstream_version 0.23

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_5

Summary:    Automatically enable coercions for Moose attributes
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/MooseX/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(Module/Build/Tiny.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Moose/Exporter.pm)
BuildRequires: perl(Moose/Role.pm)
BuildRequires: perl(Moose/Util/MetaRole.pm)
BuildRequires: perl(Moose/Util/TypeConstraints.pm)
BuildRequires: perl(MooseX/ClassAttribute.pm)
BuildRequires: perl(Package/Stash.pm)
BuildRequires: perl(Test/Fatal.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/Requires.pm)
BuildRequires: perl(if.pm)
BuildRequires: perl(namespace/autoclean.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
Have you ever spent an hour or more trying to figure out "WTF, why did my
coercion not run?" only to find out that you forgot 'coerce => 1' ?

Just load this module in your the Moose manpage class and 'coerce => 1'
will be enabled for every attribute and class attribute automatically.

Use 'coerce => 0' to disable a coercion explicitly.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Build.PL --installdirs=vendor

./Build

%check
./Build test

%install
./Build install --destdir=%{buildroot}

%files
%doc CONTRIBUTING Changes INSTALL LICENSE META.json META.yml  README
%{perl_vendor_privlib}/*

%changelog
