# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name MooseX-Attribute-ENV
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1.1
Summary: Set default of an attribute to a value from %%ENV
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JJ/JJNAPIORK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This is a the Moose manpage attribute trait that you use when you want the default value
for an attribute to be populated from the %%ENV hash.  So, for example if you
have set the environment variable USERNAME = 'John' you can do:

	package MyApp::MyClass;

	use Moose;
	use MooseX::Attribute::ENV;

	has 'username' => (is=>'ro', traits=>['ENV']);

	package main;

	my $myclass = MyApp::MyClass->new();

	print $myclass->username; # STDOUT => 'John';

This is basically similar functionality to something like:

	has 'attr' => (
		is=>'ro',
		default=> sub {
			$ENV{uc 'attr'};
		},
	);

but this module has a few other features that offer merit, as well as being a
simple enough attribute trait that I hope it can serve as a learning tool.

If the named key isn't found in %%ENV, then defaults will execute as normal.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/M*

%changelog
