# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name MooseX-AttributeDefaults
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1.1
Summary: Role to provide default option for your attribute 
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/F/FR/FRODWITH/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Although you can do similar things by overriding attributes in subclasses of
Moose::Meta::Attribute, there are a couple of gotchas (as of this writing, for
instance, overriding 'is' does nothing at all).  This role abstracts the 
implementation details of the available workarounds.

    package My::Custom::Metaclass;
    use Moose;

    extends 'Moose::Meta::Attribute';
    with    'MooseX::AttributeDefaults';

    sub default_options {
      my ($class, $name) = @_;
      
      return (
        is      => 'ro',
        isa     => 'Str',
        default => "default value for $name";
      );
    }

    package Some::Class;
    use Moose;

    has 'attr' => (
      metaclass => 'My::Custom::Metaclass',
      predicate => 'has_attr',
    );

    # 'attr' is a ro string with "default value for attr" as its 
    # default and a 'has_attr' predicate

    ### Or as a trait instead of a metaclass
    
    package Acme::Common::Array;
    use Moose::Role;

    with qw(MooseX::AttributeDefaults);

    sub default_options {
      is      => 'ro',
      isa     => 'ArrayRef',
      default => sub { [] },
    }

    package Some::Class;
    use Moose;
    use MooseX::AttributeHelpers;

    has attr => (
      metaclass => 'Collection::Array',
      traits    => [qw(Acme::Common::Array)],
      provides  => {
        'push' => 'add_attr',
      },
    );


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/M*

%changelog
