# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Cwd.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(JSON.pm) perl(Module/Runtime.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(MooseX/ClassAttribute.pm) perl(Test/More.pm) perl(Try/Tiny.pm) perl(YAML.pm)
# END SourceDeps(oneline)
%define module_name MooseX-ConfigCascade
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Set initial accessor values of your whole Moose-based project from a single config file
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOMGRACEY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
In my opinion getting values from some kind of centralised config to attributes in nested objects is problematic. There are several modules available which load config into accessors, but in one way or another these all involve telling each specific object about the config, and changing the code of each package to accommodate that config.

the MooseX::ConfigCascade manpage attempts to solve not only the issue of loading from a centralised config file, but also delivery of config values to objects within objects, nested to arbitrary depth, without the need for any added code within the modules. Specify a config file once (perhaps at the top of your script), and from then on any object you create can enjoy having its attributes loaded directly from the config.

If you don't specify a config file, the object will just initialise with the default values it was going to take otherwise. Nor is there any requirement for how many attributes you choose to put in your config. Load lots of them, or just one. Any that don't get a definition in your config file will load package default values as before.

the MooseX::ConfigCascade manpage also allows CSS style cascading of config declarations. In the example in the synopsis, the attributes 'company_name' and 'slogan' (belonging to the My::Logo package) were assigned values 3 times in the configuration file. The most specific definition in the config that matches the object structure wins. So in the example, if My::Logo is initialised on its own, then it will get the value provided in the `My::Logo' directive in the config file. If the `My::Logo' object is initialised in the accessor `logo' in `My::Label' however, the more specific `My::Label' definition wins.

This module was born out of frustration with the paradox of trying to make sure config remains centralised while also keeping objects independent of one another. A tempting and easy way to deal with config is simply to pass a reference around to all objects that need it in your project. This works great, but it ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/M*

%changelog
