%define module_version 0.006
%define module_name MooseX-ConstructInstance
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Module/Runtime.pm) perl(Moo.pm) perl(Moo/Role.pm) perl(Moose.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(if.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.006
Release: alt1.1
Summary: small wrapper method for instantiating helper objects
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/MooseX-ConstructInstance

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Normally you would build an LWP::UserAgent something like this:

   sub _build_ua {
      my $self = shift;
      LWP::UserAgent->new(...);
   }

Following the principles of dependency injection, you may prefer not to
hard-code the class name (see also the MooseX::RelatedClasses manpage):

   has ua_class => (is => 'ro', default => 'LWP::UserAgent');
   
   sub _build_ua {
      my $self = shift;
      $self->ua_class->new(...);
   }

This module allows you to take it to a further level of abstraction:

   has ua_class => (is => 'ro', default => 'LWP::UserAgent');
   
   sub _build_ua {
      my $self = shift;
      $self->construct_instance($self->ua_class, ...);
   }

Why? What benefit do we accrue from constructing all our helper objects via
a seemingly redundant object method call? How about this:

   {
      package Authentication;
      use Moose::Role;
      around construct_instance => sub {
         my ($orig, $self, $class, @args) = @_;
         my $instance = $self->$orig($class, @args);
         if ($instance->DOES('LWP::UserAgent')) {
            $instance->credentials('', '', 'username', 'password');
         }
         return $instance;
      };
   }
   
   Moose::Util::ensure_all_roles($something, 'Authentication');

Now whenever `$something' constructs an LWP::UserAgent object, it will
automatically have authentication credentials supplied.

MooseX::ConstructInstance can be used to apply policies such as:

=over

=item *

If `$foo' has a `dbh' attribute, and it constructs an object
`$bar', then `$bar' should inherit `$foo''s database
handle.

=item *

All node objects must be have "backlinks" to the parent node that created
them.

=back

Despite the name, MooseX::ConstructInstance is actually a the Moo::Role manpage.
You can apply MooseX::ConstructInstance to Moose classes using:

   package MyClass;
   use Moose;
   with qw( MooseX::ConstructInstance );

You can apply it to Moo classes using:

   package MyClass;
   use Moo;
   with qw( MooseX::ConstructInstance );

You can apply it to other classes using:

   package MyClass;
   use MooseX::ConstructInstance -with;


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYRIGHT Changes LICENSE README examples
%perl_vendor_privlib/M*

%changelog
