%define module_name MooseX-DataModel
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Printer.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON/MaybeXS.pm) perl(Moose.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Types/Standard.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: Create object models from datastructures
Group: Development/Perl
License: apache
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JL/JLMARTIN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Working with "plain datastructures" (nested hashrefs, arrayrefs and scalars) that come from other 
systems can be a pain.

Normally those datastructures are not arbitrary: they have some structure to them: most of them 
come to express "object like" things. MooseX::DataModel tries to make converting these datastructures
into objects in an easy, declarative fashion.

Lots of times

MooseX::DataModel also helps you validate the datastructures. If you get an object back, it conforms
to your object model. So if you declare a required key, and the passed datastructure doesn't contain 
it: you will get an exception. If the type of the key passed is different from the one declared: you
get an exception. The advantage over using a JSON validator, is that after validation you still have
your original datastructure. With MooseX::DataModel you get full-blown objects, to which you can
attach logic.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes
%perl_vendor_privlib/M*

%changelog
