%define module_version 0.003
%define module_name MooseX-NiftyDelegation
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(Scalar/Util.pm) perl(Sub/Exporter.pm) perl(Test/More.pm) perl(thanks.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1.1
Summary: extra sugar for method delegation
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/MooseX-NiftyDelegation

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Moose has an undocumented feature whereby you can delegate methods to.coderefs like this:

   has status => (
      is       => 'rw',
      isa      => 'Str',
      handles  => {
         is_in_progress  => sub {
            my $self = shift;
            $self->status eq 'in progress';
         },
      },
   );

Kinda ugly though. The `MooseX::NiftyDelegation::Trait::Attribute' trait
pretties it up a little by automatically wrapping the coderef with a little
gubbin that sets `$_' to `$self->$attribute'. Thus:

   has status => (
      is       => 'rw',
      isa      => 'Str',
      traits   => ['MooseX::NiftyDelegation::Trait::Attribute'],
      handles  => {
         is_in_progress  => sub { $_ eq 'in progress' },
      },
   );

A little prettier. The rest of `MooseX::NiftyDelegation' gives you some
handy functions to make these coderefs a cuter still...

=over

=item `Nifty'

This is a constant which returns the string
`'MooseX::NiftyDelegation::Trait::Attribute'' so you don't have to
type that out every time. It is exported by default.

=item `value_is $number'

Returns a coderef that evaluates `$_' for numeric equality with the
given number. This function is not exported by default.

=item `value_is $string'

Returns a coderef that evaluates `$_' for string equality with the
given string. This function is not exported by default.

=item `value_like $regexp'

Returns a coderef that evaluates `$_' for matching the given
regular expression. This function is not exported by default.

=back

Now, why would you want to stuff these "delegted" methods into attributes?
Why not just write them as regular methods?

   sub is_in_progress {
      my $self = shift;
      $self->status eq 'in progress';
   }

A good question. Writing methods which are closely associated with a
single attribute as delegated methods just seems to me to be a nice
way of grouping related methods. You can even use it for builders:

   has user_agent => (
      is         => 'ro',
      isa        => 'Object',
      lazy_build => 1,
      handles    => {
         get               => 'get',
         _build_user_agent => sub { LWP::UserAgent->new },
      },
   );


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README COPYRIGHT Changes
%perl_vendor_privlib/M*

%changelog
