Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(MooseX/Meta/TypeConstraint/Mooish.pm) perl(Net/FTP.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:       perl-MooseX-Role-XMLRPC-Client 
Version:    0.07
Release:    alt2_29
# lib/MooseX/Role/XMLRPC/Client.pm -> LGPLv2+
# Automatically converted from old format: LGPLv2+ - review is highly recommended.
License:    LicenseRef-Callaway-LGPLv2+

Summary:    Provide the needed bits to be a XML-RPC client 
Source:     https://cpan.metacpan.org/authors/id/R/RS/RSRCHBOY/MooseX-Role-XMLRPC-Client-%{version}.tar.gz
Url:        https://metacpan.org/release/MooseX-Role-XMLRPC-Client
BuildArch:  noarch

BuildRequires: rpm-build-perl
BuildRequires: perl(Crypt/SSLeay.pm)
BuildRequires: perl(File/Find.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(HTTP/Cookies.pm)
BuildRequires: perl(Module/Install.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(MooseX/AttributeShortcuts.pm)
BuildRequires: perl(MooseX/Role/Parameterized.pm)
BuildRequires: perl(MooseX/Types/Moose.pm)
BuildRequires: perl(MooseX/Types/Path/Class.pm)
BuildRequires: perl(MooseX/Types/URI.pm)
BuildRequires: perl(namespace/clean.pm)
BuildRequires: perl(RPC/XML/Client.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/Requires.pm)


Source44: import.info

%description
This is a Moose role that provides the methods and attributes needed 
to enable a class to serve as an XML-RPC client.  It is parameterized
through MooseX::Role::Parameterized, so you can customize how it embeds
in your class. You can even embed it multiple times with different
paramaterization, if it strikes your fancy :-)


%prep
%setup -q -n MooseX-Role-XMLRPC-Client-%{version}

# This module bundles an old version of Module::Install
# This is against Fedora policy so we replace it with
# the system version
rm -rf inc/Module
cp -r %{perl_vendor_privlib}/Module inc/

# This fails. Remove it until we figure out why
sed -i -e 's/extra_tests;//' Makefile.PL

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -exec rm -f {} ';'

# %{_fixperms} %{buildroot}/*

%check
%{?!_with_network_tests: NO_NET_TESTS=1} make test

%files
%doc Changes README 
%{perl_vendor_privlib}/MooseX*

%changelog
