Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Build.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-MooseX-SimpleConfig
Version:        0.11
Release:        alt2_31
Summary:        Moose role for setting attributes from a simple configfile
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/MooseX-SimpleConfig
Source0:        https://cpan.metacpan.org/modules/by-module/MooseX/MooseX-SimpleConfig-%{version}.tar.gz
BuildArch:      noarch
# Build:
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Module/Build/Tiny.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl(Config/Any.pm)
BuildRequires:  perl(Moose/Role.pm)
BuildRequires:  perl(MooseX/ConfigFromFile.pm)
# Tests:
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(File/Spec/Functions.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Moose.pm)
BuildRequires:  perl(Test/Fatal.pm)
BuildRequires:  perl(Test/More.pm)
# Optional tests:
BuildRequires:  perl(CPAN/Meta.pm)
BuildRequires:  perl(CPAN/Meta/Prereqs.pm)
BuildRequires:  perl(YAML/Syck.pm)
# Dependencies
Requires:       perl(MooseX/ConfigFromFile.pm)
Source44: import.info

%description
This role loads simple configfiles to set object attributes. It is based on
the abstract role MooseX::ConfigFromFile, and uses Config::Any to load your
configfile. Config::Any will in turn support any of a variety of different
configuration formats, detected by the file extension. See Config::Any for
more details about supported formats.

%prep
%setup -q -n MooseX-SimpleConfig-%{version}

%build
perl Build.PL --installdirs=vendor
./Build

%install
./Build install --destdir=%{buildroot} --create_packlist=0
# %{_fixperms} -c %{buildroot}

%check
./Build test

%files
%doc --no-dereference LICENSE
%doc Changes CONTRIBUTING README
%{perl_vendor_privlib}/MooseX/

%changelog
