Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-MooseX-Types-DateTime-ButMaintained
Version:        0.16
Release:        alt2_38
Summary:        DateTime related constraints and coercions for Moose
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/MooseX-Types-DateTime-ButMaintained
Source0:        https://cpan.metacpan.org/authors/id/E/EC/ECARROLL/MooseX-Types-DateTime-ButMaintained-%{version}.tar.gz
# Accept DateTime::TimeZone::Tzfile object in place of DateTime::TimeZone,
# bug #1138185
Patch0:         MooseX-Types-DateTime-ButMaintained-0.16-Accept-DateTime-TimeZone-Tzfile-object-in-place-of-D.patch
# Accept DateTime::Locale::FromData object in place of DateTime::Locale,
# bug #1283970
Patch1:         MooseX-Types-DateTime-ButMaintained-0.16-Accept-DateTime-Locale-FromData-object.patch
BuildArch:      noarch

BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(inc/Module/Install.pm)
BuildRequires:  perl(Module/Install/AutoInstall.pm)
BuildRequires:  perl(Module/Install/Metadata.pm)
BuildRequires:  perl(Module/Install/WriteAll.pm)
# Run-time:
# DateTime >= 0.4302 rounded to two places
BuildRequires:  perl(DateTime.pm)
# DateTime::Locale >= 0.4001 rounded to two places
BuildRequires:  perl(DateTime/Locale.pm)
BuildRequires:  perl(DateTime/TimeZone.pm)
BuildRequires:  perl(Moose.pm)
BuildRequires:  perl(MooseX/Types.pm)
BuildRequires:  perl(MooseX/Types/Moose.pm)
BuildRequires:  perl(namespace/autoclean.pm)
BuildRequires:  perl(Olson/Abbreviations.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Tests only
BuildRequires:  perl(Locale/Maketext.pm)
BuildRequires:  perl(Moose/Util/TypeConstraints.pm)
BuildRequires:  perl(Test/Exception.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/use/ok.pm)
# DateTime >= 0.4302 rounded to two places
Requires:       perl(DateTime.pm) >= 0.440
# DateTime::Locale >= 0.4001 rounded to two places
Requires:       perl(DateTime/Locale.pm) >= 0.410
Requires:       perl(DateTime/TimeZone.pm) >= 0.960

# Do not export under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(DateTime\(\|.Locale\|.TimeZone\)\\)\\s*$/d

%description
This module packages several Moose::Util::TypeConstraints with coercions,
designed to work with the DateTime suite of objects.

%prep
%setup -q -n MooseX-Types-DateTime-ButMaintained-%{version}
%patch0  -p1
%patch1  -p1

# Remove bundled libraries
rm -r inc
sed -i -e '/^inc\// d' MANIFEST
find -type f -exec chmod -x {} +

%build
# switch off cpan installation
PERL5_CPANPLUS_IS_RUNNING=1 perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -delete
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes
%{perl_vendor_privlib}/*

%changelog
