# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dump.pm) perl(Devel/PartialDump.pm) perl(Digest/MD5.pm) perl(ExtUtils/MakeMaker.pm) perl(Moose.pm) perl(MooseX/NonMoose.pm) perl(MooseX/Types.pm) perl(MooseX/Types/Structured.pm) perl(Scalar/Util.pm) perl(Set/Scalar.pm) perl(Test/Most.pm) perl(Test/Requires.pm)
# END SourceDeps(oneline)
%define module_name MooseX-Types-Parameterizable
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: Create your own Parameterizable Types for Moose
Group: Development/Perl
License: perl
URL: https://github.com/jjn1056/MooseX-Types-Parameterizable

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JJ/JJNAPIORK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
A the MooseX::Types manpage library for creating parameterizable types.  A parameterizable
type constraint for all intents and uses is a subclass of a parent type, but
adds additional type parameters which are available to constraint callbacks
(such as inside the 'where' clause of a type constraint definition) or in the
coercions you define for a given type constraint.

If you have the Moose manpage experience, you probably are familiar with the builtin
parameterizable type constraints 'ArrayRef' and 'HashRef'.  This type constraint
lets you generate your own versions of parameterized constraints that work
similarly.  See the Moose::Util::TypeConstraints manpage for more.

Using this type constraint, you can generate new type constraints that have
additional runtime advice, such as being able to specify maximum and minimum
values for an Int (integer) type constraint:

    subtype Range,
        as Dict[max=>Int, min=>Int],
        where {
            my ($range) = @_;
            return $range->{max} > $range->{min};
        };

    subtype RangedInt,
        as Parameterizable[Int, Range],
        where {
            my ($value, $range) = @_;
            return ($value >= $range->{min} &&
             $value <= $range->{max});
        },
                message {
            my ($value, $range) = @_;
                        return "$value must be between $range->{min} and $range->{max} (inclusive)";
                };

    RangedInt([{min=>10,max=>100}])->check(50); ## OK
    RangedInt([{min=>50, max=>75}])->check(99); ## Not OK, exceeds max

This is useful since it lets you generate common patterns of type constraints
rather than build a custom type constraint for all similar cases.

The type parameter must be valid against the 'constrainting' type constraint used
in the Parameterizable condition.  If you pass an invalid value this throws a
hard Moose exception.  You'll need to capture it in an eval or related exception
catching system (see the TryCatch manpage or the Try::Tiny manpage.)

For example th...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes README.mkdn
%perl_vendor_privlib/M*

%changelog
