# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Chart/ErrorBars.pm) perl(ExtUtils/MakeMaker.pm) perl(GD.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Statistics/Lite.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name MultiSkan
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: The great new MultiSkan!
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/L/LO/LOGUST/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Used Multiskan Microplate Photometer (Thermo Scientific) for your experiment? 
 
Just got a text file as your output? 
 
Thinking it would be good if it had an app to give you an overview of all wells, and to help to group the data and do some simple stats for you?

GOOD! That means I'm not alone. This module does some simple tasks for you...

    use MultiSkan;
    
    my @groups = (
        'amp', 'A2B2C2',
        'tet', 'A4B4C4',
        'Blank', 'A1B1C1',
 
    );
    my $data_file = 'GrowthCurve.TXT';
    open my $fh, '<', $data_file;
    my $ms = MultiSkan->new(fh => $fh);
    my $A1 = $ms->A1; # quering well A1

You can use

    my %%data = $ms->group_stats(@groups); 

to get the averages and standard deviations for each groups.
Well, you can use `my @groups = qw/.../`, but then you lose the ability to comment out the groups you don't want for the final report...
 
If you want to write the data to a file to be processed by other apps (which usually require the data to be arranged in a column-wise fashion, then you can use this snippet:
    
    my @time = @{$ms->time};
    @time = map {$_/60} @time;
 
    my %%data = $ms->group_stats(@groups);
 
    open my $oh, '>', 'report.txt';
 
    print $oh "time";
 
    for (my $i=0;$i<@groups;$i+=2){
        print $oh "\t$groups[$i]\tStdev";
    }
 
    print $oh "\n";
 
 
    for my $i (0..$#time){
        print $oh $time[$i];
        for (my $g=0;$g<@groups;$g+=2){
 
        print $oh "\t".$data{$groups[$g]}->{average}[$i]."\t".$data{$groups[$g]}->{stddev}[$i];
        }
        print $oh "\n";
    }
 
You can use the following function to draw an overview to check out all the 96 wells in a glimpse.
 
    $ms->draw_all_curves('all_curves.png');

Or you can draw a selected set of data with averages and error bars...
 
    my %%data = $ms->group_stats(@groups);
    $ms->draw_curves(
        'out_img' => 'curves.png',
        'height'  => 768,
        'width'   => 1024,
        'time'    => \@time,
        'data'    => \%%data,
        'parameters' => {
            'min_val' => 0,
            'max_val' => 10,
            ...
        },
    );

Since "draw_curves" uses "Chart::ErrorBars" to draw the curves, you can pass all the valid "Chart::ErrorBars" parameters as part of the "parameters" argument.




%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/M*

%changelog
