# BEGIN SourceDeps(oneline):
BuildRequires: perl(DirHandle.pm) perl(ExtUtils/MakeMaker.pm) perl(File/stat.pm) perl(FileHandle.pm)
# END SourceDeps(oneline)
%define module_version 0.5
%define module_name MultiTail
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.5
Release: alt1
Summary: Tail multiple files for Unix systems
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SG/SGMIANO/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This perl library uses perl5 objects to make it easy to
 tail a dynamic list of files and match/except lines using full
 regular expressions.

File::MultiTail;

	will tail multiple files and return the records 
	read to a Data Structure. The Data Structure can 
	be processed by MultiTail functions

The  files  specified  are processed in accordance with the 
following rules:

Note: File devices and inode number uniquely identify each entry 
in the UNIX filesystem. If the stat() command shows them to be 
the same, then only one will be used. Windows NT filesystem
NTFS does not allow links so I don't check for links on NT.

(1) Files that exist at program start  time  will  be  
    positioned to Object attribute "NumLines" before input.

(2) Files that become available subsequently  will  be  read
    from the beginning. Attribute ScanForFiles must be set to
    True (>=1) for the option. 

(3) If a file that has been selected as per rules 1 or 2  is
    deleted  or  truncated input will continue until end-of-file
    is reached before the file is closed.

(4) If a file is deleted and  it is recreated it
    is treated as a new file, will  be  read
    from the beginning

(5) To conserve file descriptors, files that are selected for
    input  are  not actually opened until data is present beyond
    the input point selected.  For example,
    if a file exists when ptail starts, ptail will determine the
    file mtime at that time and only open the file when the  mtime
    increases.

    Note: mtime = Time when data was last modified. Changed by  the
                  following functions: creat, mknod, pipe, utime,
                  and write.

(6) If an opened file has not been updated for MultiTail Object attribute
    "MaxAge" minutes it will be closed.  
    It will be reopened if it is later updated.

(7) Since MultiTail is OO you can alway change its attributes. If you change
    the list of file to be tailed (Files attribute) the attribute
    ScanForFiles will set to true and all dir and files ilists will be
    check for new files.



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/F*

%changelog
