# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(JSON/MaybeXS.pm) perl(LWP.pm) perl(Moo.pm) perl(Test/More.pm) perl(URI.pm) perl(namespace/clean.pm) perl(strictures.pm)
# END SourceDeps(oneline)
%define module_name Museum-EICAS
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: A simple interface to the EICAS museum API
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RS/RSHEAT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Provides access to the bulk items, individual item, and media endpoints from
the EICAS (European Institute for Contemporary Art and Science.) See
https://collectie.eicas.nl/api/items?per_page=10 for an example of how the
API looks.

    use Museum::EICAS;

    my $m = Museum::EICAS->new();

    # Returns an arrayref of all the data.
    my $all = $m->get_items();
   
    # Get a particular item
    my $item = $m->get_item(42);

    # Get media data for an item
    my $media = $m->get_media($item);

    # Or for a particular media ID (not item ID)
    my $media = $m->get_media(69);

The data is returned pretty much as it comes from the endpoint, converted into
a Perl structure.

Generally calls die on failure.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE
%perl_vendor_privlib/M*

%changelog
