# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(JSON/MaybeXS.pm) perl(LWP.pm) perl(Moo.pm) perl(Test/More.pm) perl(URI/QueryParam.pm) perl(namespace/clean.pm) perl(strictures.pm)
# END SourceDeps(oneline)
%define module_name Museum-TePapa
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: an interface to the Te Papa museum API
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RS/RSHEAT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This provides handy methods for access the various endpoints of the Te Papa
museum API. See https://data.tepapa.govt.nz/docs/index.html for information
on them. You will need an API key, this doesn't handle the guest key mechanism.

    use Museum::TePapa;

    my $tepapa = Museum::TePapa->new( key => 'yoursecretkey' );
    my $result = $tepapa->object_search( $query, { limit => 3 } );
    my $result = $tepapa->place( $id, { ... parameters ... } );
    my $result = $tepapa->taxon_related( $id, { ... parameters ... } );

    # This provides results in batches through the callback
    $tepapa->media_scroll( $callback, { ... parameters ... } );

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/M*

%changelog
