%define module_name Music-BachChoralHarmony
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/ShareDir.pm) perl(File/ShareDir/Install.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(List/Util.pm) perl(Moo.pm) perl(Pod/Coverage/TrustPod.pm) perl(Pod/Wordlist.pm) perl(Test/EOL.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Spelling.pm) perl(Test/Synopsis.pm) perl(Text/CSV.pm) perl(namespace/clean.pm) perl(strict.pm) perl(strictures.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0412
Release: alt1
Summary: Parse the UCI Bach choral harmony data set
Group: Development/Perl
License: perl
URL: https://github.com/ology/Music-BachChoralHarmony

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GE/GENE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`Music::BachChoralHarmony' parses the UCI Bach choral harmony data set of 60
chorales.

This module does a few simple things:

1. It turns the UCI CSV data into a perl data structure.

2. It converts the UCI YES/NO note specification into a bit string.

3. It combines the Bach BWV number, song title and key with the data.

The BWV and titles were collected from an old Internet Archive of
`jsbchorales.net' and filled-in from `bach-chorales.com'.  The keys were
computed with a `music21' python program and again filled-in from
`bach-chorales.com'.  Check out the links in the the SEE ALSO entry elsewhere in this document section.

See the distribution `eg/' programs for usage examples.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes README.md
%perl_vendor_privlib/M*
%perl_vendor_privlib/auto/*

%changelog
