%define module_name MySQL-GrantParser
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBI.pm) perl(Module/Build/Tiny.pm) perl(Pod/Wordlist.pm) perl(Test/Fixme.pm) perl(Test/Kwalitee.pm) perl(Test/Kwalitee/Extra.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Spelling.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.006
Release: alt1
Summary: parse SHOW GRANTS and return as hash reference
Group: Development/Perl
License: perl
URL: https://github.com/hirose31/MySQL-GrantParser

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HI/HIROSE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
MySQL::GrantParser is SHOW GRANTS parser for MySQL, inspired by Ruby's Gratan.

This module returns privileges for all users as following hash reference.

    {
        'USER@HOST' => {
            'user' => USER,
            'host' => HOST,
            'objects' => {
                'DB_NAME.TABLE_NAME' => {
                    privs => [ PRIV_TYPE, PRIV_TYPE, ... ],
                    with  => 'GRANT OPTION',
                },
                ...
            },
            'options' => {
                'identified' => '...',
                'required'   => '...',
            },
        },
        {
            ...
        },
    }

For example, this GRANT statement

    GRANT SELECT, INSERT, UPDATE, DELETE ON orcl.* TO 'scott'@'%%' IDENTIFIED BY 'tiger' WITH GRANT OPTION;

is represented as following.

    {
        'scott@%%' => {
            user => 'scott',
            host => '%%',
            objects => {
                '*.*' => {
                    privs => [
                        'USAGE'
                    ],
                    with => '',
                },
                '`orcl`.*' => {
                    privs => [
                        'SELECT',
                        'INSERT',
                        'UPDATE',
                        'DELETE',
                    ],
                    with => 'GRANT OPTION',
                }
            },
            options => {
                identified => "PASSWORD XXX",
                required => '',
            },
        },
    }



%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/M*

%changelog
