# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/mysqlimport perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(DBD/mysql.pm) perl(DBI.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(IO/File.pm) perl(IO/File/flock.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(List/MoreUtils.pm) perl(Mknod.pm) perl(Module/Build.pm) perl(Moose.pm) perl(MooseX/GlobRef/Object.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm) perl(self.pm) perl(MooseX/Getopt.pm) perl(B/OPCheck.pm)
# END SourceDeps(oneline)
%define module_version 0.28
%define module_name MySQL-Slurp
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.28
Release: alt1.1
Summary: Use PIPEs to write directly to a MySQL table
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/C/CT/CTBROWN/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
MySQL::Slurp provides methods for writing directly to a MySQL table
using a convenient interface. This module creates a writable FIFO and
uses `mysqlimport' or `LOAD DATA INFILE' to load whatever is written
to that FIFO.  This is the fastest method for importing data into a 
MySQL table.  This module makes it easy.  The user needs only `open',
`write', and `close' a MySQL::Slurp object.

This module also provides a `slurp' method for reaing directly from 
<STDIN> and writing to the table.  This allows you to do tasks such 
as the following: 

    cat data.tsv | perl myscript.pl   

This is very handy for large ETL jobs.

Unike using the DBI manpage for trapping errors, catching errors with 
mysqlimport can be troublesome with inconsitent data.  It is 
recommended that you check you data before writing to the MySQL::Slurp
handle or use a suitable the DBI manpage method.  

The module also implements buffering and locking using 
the MySQL::Slurp::Writer manpage.  This allows for multi-process and multi-
threading.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name



%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install
# strange perls in '#!'
fix_shabang_in_perl()
{
	local f="$1"
	#!/usr/bin/perl -w -- -*- mode: cperl -*-
	sed -i -e '1s,^#\!\(/usr\)\?/bin/env[[:space:]]*perl,#!/usr/bin/perl,;1s,-\*-[[:space:]]*cperl[[:space:]]*-\*-,,;1s,-\*-[[:space:]]*[Mm]ode:[[:space:]]*[Cc]?[pP]erl[[:space:]]*-\*-,,' $f 
	sed -i -e '1s,^#\!/usr/local/bin/perl,#!/usr/bin/perl,' $f 
}
for dir in %buildroot%_bindir %buildroot%perl_vendor_archlib %buildroot%perl_vendor_privlib ; do
    if [ -d $dir ]; then
    	find $dir -type f -executable | while read f; do
	  case `file $f` in
	    *perl*) fix_shabang_in_perl $f 
	    ;;
	  esac
	done
	find $dir -type f \( -name '*.pm' -or -name '*.pl' \) | while read f; do
	  fix_shabang_in_perl $f
	done
    fi
done


%files
%doc README Changes examples
%perl_vendor_privlib/M*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
